IF EXISTS ( SELECT * 
            FROM   sysobjects 
            WHERE  id = object_id(N'dbo.CF_Banco_Roela_AR_CB') 
                   and type = 'FN')
BEGIN
    DROP FUNCTION dbo.CF_Banco_Roela_AR_CB
END
GO

CREATE FUNCTION [dbo].[CF_Banco_Roela_AR_CB](@pId_Trans INT, @pImporte DECIMAL(12,2), @pId_Tar_Lote INT, @pPeriodo DATETIME) 
RETURNS CHAR(56)
AS
BEGIN
/*Variable de Retorno*/
DECLARE @Retorno				CHAR(56)
/*FIN Variable de Retorno*/

IF EXISTS ( SELECT * FROM sysobjects WHERE id = object_id(N'dbo.CF_Banco_Roela_AR_CB_') AND type = 'FN')
BEGIN
    SET @Retorno = dbo.CF_Banco_Roela_AR_CB_(@pId_Trans, @pImporte, @pId_Tar_Lote, @pPeriodo)
	RETURN @Retorno
END

/*Variables del Archivo*/
DECLARE @aEmpresaServicio		CHAR(4)		/*Empresa de Servicio.			Tipo: Numerico. Long: 04. Desde: 001. Hasta: 004. Descripcion: Fijo: 0447*/
DECLARE @aId_Concepto			CHAR(1)		/*Identificador de Concepto.	Tipo: Numerico. Long: 01. Desde: 005. Hasta: 005. Descripcion: Digito a su disposicion y puede referirse a distintos conceptos que factura el ente. Ej: 1: Alquileres, 2: expensas, 3: Cuota, 4: seguro de vida, 5: cliente VIP, etc*/
DECLARE @aId_Usuario			CHAR(8)		/*Identificador de Usuario.		Tipo: Numerico. Long: 08. Desde: 006. Hasta: 013. Descripcion: Codigo para identificar a clientes que van a abonar. Ej: DNI, Legajo, Unidad Funcional, factura, etc*/
DECLARE @aFch_1Venc				CHAR(6)		/*Fecha 1er Vto.				Tipo: Numerico. Long: 06. Desde: 014. Hasta: 019. Descripcion: Formato AAAAMMDD.*/
DECLARE @aImporte_1Venc			CHAR(7)		/*Importe 1er Vto.				Tipo: Numerico. Long: 07. Desde: 020. Hasta: 026. Descripcion: Monto a Cobrar (5 enteros, 2 decimales). */
DECLARE @aDias2Venc				CHAR(2)		/*Dias hasta 2do Vto.			Tipo: Numerico. Long: 02. Desde: 027. Hasta: 028. Descripcion: Cantidad de dias corridos entre el 1er y 2do vencimiento. Si no usa segundo vencimiento, completar con 0 (cero)*/
DECLARE @aImporte_2Venc			CHAR(7)		/*Importe 2do Vto.				Tipo: Numerico. Long: 07. Desde: 029. Hasta: 035. Descripcion: Monto a Cobrar (5 enteros, 2 decimales).  Si no usa segundo vencimiento, completar con 0 (cero)*/
DECLARE @aDias3Venc				CHAR(2)		/*Dias hasta 3er Vto.			Tipo: Numerico. Long: 02. Desde: 036. Hasta: 037. Descripcion: Cantidad de dias corridos entre el 2do y 3er vencimiento. Si no usa segundo vencimiento, completar con 0 (cero)*/
DECLARE @aImporte_3Venc			CHAR(7)		/*Importe 3er Vto.				Tipo: Numerico. Long: 07. Desde: 038. Hasta: 044. Descripcion: Monto a Cobrar (5 enteros, 2 decimales).  Si no usa segundo vencimiento, completar con 0 (cero)*/
DECLARE @aId_Cuenta				CHAR(10)	/*Identificado de Cuenta		Tipo: Numerico. Long: 10. Desde: 045. Hasta: 054. Descripcion: Otorgado por Banco Roela*/
DECLARE @aDigito_Verif_1		CHAR(1)		/*Digito Verificador 1.			Tipo: Numerico. Long: 01. Desde: 055. Hasta: 055. Descripcion: Ver Anexo*/
DECLARE @aDigito_Verif_2		CHAR(1)		/*Digito Verificador 2.			Tipo: Numerico. Long: 01. Desde: 056. Hasta: 056. Descripcion: Ver Anexo*/
/*FIN Variables del Archivo*/

/*Variables Locales*/
DECLARE @Cadena_A_Verificar				CHAR(54)
DECLARE	@i								TINYINT
DECLARE @Mult_Paso2						INT
DECLARE @Suma_Paso3						INT
DECLARE @Division_Paso4					DECIMAL(12,2)
DECLARE @Modulo_Paso5					DECIMAL(12,2)
DECLARE @Cadena_A_Verificar2			CHAR(55)

DECLARE @Id_Tarjeta						VARCHAR(10)

DECLARE @1_Vto_Porc_Recargo				DECIMAL(12,5)
DECLARE @1_Vto_Plazo_Desde				INT
DECLARE @1_Vto_Plazo_Hasta				INT
DECLARE @2_Vto_Porc_Recargo				DECIMAL(12,5)
DECLARE @2_Vto_Plazo_Desde				INT
DECLARE @2_Vto_Plazo_Hasta				INT
DECLARE @3_Vto_Porc_Recargo				DECIMAL(12,5)
DECLARE @3_Vto_Plazo_Desde				INT
DECLARE @3_Vto_Plazo_Hasta				INT

DECLARE @Comercio_Nro					VARCHAR(50)
DECLARE @Id_Cliente						INT
DECLARE @Id_Contrato					INT
DECLARE @Comprobante_Nro				INT
DECLARE @Importe_Cbte					DECIMAL(12,2)
DECLARE @Fecha_Cbte						DATETIME
DECLARE @Id_Cliente_Externo				VARCHAR(14)
DECLARE @Id_Cliente_Ref					INT
DECLARE @Doc_Nro						BIGINT
DECLARE @Tipo_Persona					CHAR(1)
DECLARE @Id_Tipo_Cbte					VARCHAR(4)
DECLARE @Id_Cliente_Externo_Tit			VARCHAR(14)
DECLARE @Id_Cond_Pago					SMALLINT
/*FIN Variables Locales*/

-------------------------------------------------------------------------------------------------------------------------------------------------------------------

/*Seteo Variables Locales*/

SET @Id_Tarjeta			= dbo.CF_xParam('Id_Banco_Roela_AR')

SELECT
@Comercio_Nro			= LTRIM(RTRIM(ISNULL(Comercio_Nro, '')))
FROM Valores_Tarjetas_Cred
WHERE
ISNULL(Id_Tarjeta, '') = @Id_Tarjeta

SELECT	
@Id_Cliente				= ISNULL(Id_Cliente, 0),
@Fecha_Cbte				= ISNULL(Fecha, '19000101'),
@Id_Contrato			= ISNULL(Id_Contrato, 0),
@Comprobante_Nro		= ISNULL(Comprobante_Nro, 0),
@Id_Tipo_Cbte			= ISNULL(Id_Tipo_Cbte, ''),
@Importe_Cbte			= ISNULL(Imp_Total, 0)
FROM Cbtes 
WHERE
Id_Trans = @pId_Trans

SELECT
@Id_Cond_Pago			= ISNULL(Id_Cond_Pago, 0)
FROM Productos
WHERE
Id_Producto = dbo.CF_xParam('Prod_Cuota_Social')

SELECT 
@Id_Cliente_Externo		= ISNULL(Id_Cliente_Externo, Id_Cliente),
@Id_Cliente_Ref			= ISNULL(Id_Cliente_Ref, 0),
@Doc_Nro				= ISNULL(Doc_Nro, 0),
@Tipo_Persona			= ISNULL(Tipo_Persona, 'F')
FROM Clientes 
WHERE 
Id_Cliente = @Id_Cliente

SELECT 
@Id_Cliente_Externo_Tit		= ISNULL(Id_Cliente_Externo, Id_Cliente)
FROM Clientes 
WHERE 
Id_Cliente = @Id_Cliente_Ref

SELECT 
@1_Vto_Porc_Recargo		= ISNULL(Porc_Bonif, 0),
@1_Vto_Plazo_Desde		= ISNULL(Plazo_Desde, 0),
@1_Vto_Plazo_Hasta		= ISNULL(Plazo_Bonif, 0)
FROM Cbtes_Cond_Pago_Items 
WHERE 
Id_Cond_Pago = @Id_Cond_Pago 
AND Tipo = 'P'
AND Id_Cond_Pago_Item = 1

IF(@1_Vto_Porc_Recargo = CONVERT(DECIMAL(12,5), 0))
BEGIN
	SET @1_Vto_Porc_Recargo = CONVERT(DECIMAL(12,5), 1)
END
ELSE
BEGIN
	SET @1_Vto_Porc_Recargo = (@1_Vto_Porc_Recargo / 100) + 1
END

SELECT 
@2_Vto_Porc_Recargo		= ISNULL(Porc_Bonif, 0),
@2_Vto_Plazo_Desde		= ISNULL(Plazo_Desde, 0),
@2_Vto_Plazo_Hasta		= ISNULL(Plazo_Bonif, 0)
FROM Cbtes_Cond_Pago_Items 
WHERE 
Id_Cond_Pago = @Id_Cond_Pago 
AND Tipo = 'P'
AND Id_Cond_Pago_Item = 2

IF(@2_Vto_Porc_Recargo = CONVERT(DECIMAL(12,5), 0))
BEGIN
	SET @2_Vto_Porc_Recargo = CONVERT(DECIMAL(12,5), 1)
END
ELSE
BEGIN
	SET @2_Vto_Porc_Recargo = (@2_Vto_Porc_Recargo / 100) + 1
END

SELECT 
@3_Vto_Porc_Recargo		= ISNULL(Porc_Bonif, 0),
@3_Vto_Plazo_Desde		= ISNULL(Plazo_Desde, 0),
@3_Vto_Plazo_Hasta		= ISNULL(Plazo_Bonif, 0)
FROM Cbtes_Cond_Pago_Items 
WHERE 
Id_Cond_Pago = @Id_Cond_Pago 
AND Tipo = 'P'
AND Id_Cond_Pago_Item = 3

IF(@3_Vto_Porc_Recargo = CONVERT(DECIMAL(12,5), 0))
BEGIN
	SET @3_Vto_Porc_Recargo = CONVERT(DECIMAL(12,5), 1)
END
ELSE
BEGIN
	SET @3_Vto_Porc_Recargo = (@3_Vto_Porc_Recargo / 100) + 1
END

-------------------------------------------------------------------------------------------------------------------------------------------------------------------

IF(@Tipo_Persona = 'I'/*Inmueble*/)
BEGIN
	IF(dbo.CF_IsNumeric(@Id_Cliente_Externo_Tit) = 1)
	BEGIN
		SET @Id_Cliente_Externo = CONVERT(VARCHAR(14), @Id_Cliente_Ref)
	END
	ELSE
	BEGIN
		SET @Id_Cliente_Externo = @Id_Cliente_Externo_Tit
	END
END
ELSE
BEGIN
	IF(dbo.CF_IsNumeric(@Id_Cliente_Externo) = 1)
	BEGIN
		SET @Id_Cliente_Externo = @Id_Cliente_Externo
	END
	ELSE
	BEGIN
		SET @Id_Cliente_Externo = CONVERT(VARCHAR(14), @Id_Cliente)
	END
END

-------------------------------------------------------------------------------------------------------------------------------------------------------------------

/*Seteo variables del Archivo*/

SET @aEmpresaServicio	= '0447'

SET @aId_Concepto		= '1'

SET @aId_Usuario		= RIGHT('00000000' + CAST(@pId_Trans AS VARCHAR), 8)

SET @aFch_1Venc			= SUBSTRING(RIGHT('0000' + CAST(DATEPART(YEAR, @Fecha_Cbte) AS VARCHAR), 4), 3, 2) + RIGHT('00' + CAST(DATEPART(MONTH, @Fecha_Cbte) AS VARCHAR), 2) + RIGHT('00' + CAST(@1_Vto_Plazo_Hasta AS VARCHAR), 2)

SET @aImporte_1Venc		= (SELECT RIGHT('0000000' + CAST(CAST(@pImporte * @1_Vto_Porc_Recargo * 100 AS INT) AS VARCHAR), 7))

SET @aDias2Venc			= RIGHT('00' + CAST((@2_Vto_Plazo_Hasta - @1_Vto_Plazo_Hasta) AS VARCHAR), 2)

SET @aImporte_2Venc		= (SELECT RIGHT('0000000' + CAST(CAST(@pImporte * @2_Vto_Porc_Recargo * 100 AS INT) AS VARCHAR), 7))

SET @aDias3Venc			= RIGHT('00' + CAST((@3_Vto_Plazo_Hasta - @2_Vto_Plazo_Hasta) AS VARCHAR), 2)

SET @aImporte_3Venc		= (SELECT RIGHT('0000000' + CAST(CAST(@pImporte * @3_Vto_Porc_Recargo * 100 AS INT) AS VARCHAR), 7))

SET @aId_Cuenta			= RIGHT('0000000000' + @Comercio_Nro, 10)

-------------------------------------------------------------------------------------------------------------------------------------------------------------------

--Digito verificador 1

SET @Cadena_A_Verificar =	@aEmpresaServicio +
							@aId_Concepto +
							@aId_Usuario +
							@aFch_1Venc +
							@aImporte_1Venc +
							@aDias2Venc +
							@aImporte_2Venc +
							@aDias3Venc +
							@aImporte_3Venc +
							@aId_Cuenta

SET @Suma_Paso3	= 0 
SET @i			= 1

WHILE (@i <= 54)
BEGIN

	IF(@i IN (1))
	BEGIN
		SET @Mult_Paso2 = SUBSTRING(@Cadena_A_Verificar, @i, 1) * 1
	END

	IF(@i IN (2,6,10,14,18,22,26,30,34,38,42,46,50,54))
	BEGIN
		SET @Mult_Paso2 = SUBSTRING(@Cadena_A_Verificar, @i, 1) * 3
	END

	IF(@i IN (3,7,11,15,19,23,27,31,35,39,43,47,51))
	BEGIN
		SET @Mult_Paso2 = SUBSTRING(@Cadena_A_Verificar, @i, 1) * 5
	END

	IF(@i IN (4,8,12,16,20,24,28,32,36,40,44,48,52))
	BEGIN
		SET @Mult_Paso2 = SUBSTRING(@Cadena_A_Verificar, @i, 1) * 7
	END

	IF(@i IN (5,9,13,17,21,25,29,33,37,41,45,49,53))
	BEGIN
		SET @Mult_Paso2 = SUBSTRING(@Cadena_A_Verificar, @i, 1) * 9
	END

	SET @Suma_Paso3 = @Suma_Paso3 + @Mult_Paso2

	SET @i = @i + 1
END

SET @Division_Paso4		= CONVERT(DECIMAL(12, 2), (@Suma_Paso3 / 2))

SET @Modulo_Paso5		= ROUND(@Division_Paso4, 0, 1) % 10

SET @aDigito_Verif_1	= CONVERT(VARCHAR(1), ROUND(CONVERT(INT, @Modulo_Paso5), 0, 1))

-------------------------------------------------------------------------------------------------------------------------------------------------------------------

--Digito verificador 2

SET @Cadena_A_Verificar2 =	@Cadena_A_Verificar +  
							@aDigito_Verif_1

SET @Suma_Paso3	= 0 
SET @i			= 1

WHILE (@i <= 55)
BEGIN	
	IF(@i IN (1))
	BEGIN
		SET @Mult_Paso2 = SUBSTRING(@Cadena_A_Verificar2, @i, 1) * 1
	END

	IF(@i IN (2,6,10,14,18,22,26,30,34,38,42,46,50,54))
	BEGIN
		SET @Mult_Paso2 = SUBSTRING(@Cadena_A_Verificar2, @i, 1) * 3
	END

	IF(@i IN (3,7,11,15,19,23,27,31,35,39,43,47,51,55))
	BEGIN
		SET @Mult_Paso2 = SUBSTRING(@Cadena_A_Verificar2, @i, 1) * 5
	END

	IF(@i IN (4,8,12,16,20,24,28,32,36,40,44,48,52))
	BEGIN
		SET @Mult_Paso2 = SUBSTRING(@Cadena_A_Verificar2, @i, 1) * 7
	END

	IF(@i IN (5,9,13,17,21,25,29,33,37,41,45,49,53))
	BEGIN
		SET @Mult_Paso2 = SUBSTRING(@Cadena_A_Verificar2, @i, 1) * 9
	END

	SET @Suma_Paso3 = @Suma_Paso3 + @Mult_Paso2

	SET @i = @i + 1
END

SET @Division_Paso4		= CONVERT(DECIMAL(12, 2), (@Suma_Paso3 / 2))

SET @Modulo_Paso5		= ROUND(@Division_Paso4, 0, 1) % 10

SET @aDigito_Verif_2	= CONVERT(VARCHAR(1), ROUND(CONVERT(INT, @Modulo_Paso5), 0, 1))

-------------------------------------------------------------------------------------------------------------------------------------------------------------------
                    
SET @Retorno =	@aEmpresaServicio		+
				@aId_Concepto			+
				@aId_Usuario			+
				@aFch_1Venc				+
				@aImporte_1Venc			+
				@aDias2Venc				+
				@aImporte_2Venc			+
				@aDias3Venc				+
				@aImporte_3Venc			+
				@aId_Cuenta				+
				@aDigito_Verif_1		+
				@aDigito_Verif_2	

-------------------------------------------------------------------------------------------------------------------------------------------------------------------
                                                        
RETURN ISNULL(@Retorno, '                                                        ')
END